/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.javaone.anagram;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.javaone.anagram.ui.Anagrams;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ShowScore implements ActionListener {

    public void actionPerformed(ActionEvent e) {
         Mode explorerMode = WindowManager.getDefault ().findMode("explorer");
         TopComponent tc = new ExplorerTopComponent ();
         explorerMode.dockInto(tc);
         tc.open();
         tc.requestActive();
     }

     private class ExplorerTopComponent extends TopComponent implements ExplorerManager.Provider {
         private ExplorerManager em;

         public ExplorerTopComponent () {
             initComponents ();
             em = new ExplorerManager();
             em.setRootContext(new BestScoresNode());
         }

         private void initComponents() {
             this.setLayout (new BorderLayout ());
             TreeView tv = new BeanTreeView ();
             tv.setRootVisible(true);
             add (tv, BorderLayout.CENTER);
         }

         @Override
         public String getDisplayName() {
             return "Best Scores";
         }

         @Override
         public int getPersistenceType () {
             return PERSISTENCE_NEVER;
         }

         public ExplorerManager getExplorerManager() {
             return em;
         }

         @Override
         protected String preferredID () {
             return Integer.toString (System.identityHashCode(em));
         }
     }

     private class BestScoresNode extends AbstractNode {
         private String displayName;
         public BestScoresNode(String name, Children ch) {
             super(ch);
             this.displayName = name;
         }

         public BestScoresNode(String name, int score, Children ch) {
             super(ch);
             this.displayName = name + " has the best score " + score;
         }

         public BestScoresNode() {
             super(new BestScoresChildren());
             this.displayName = "Best Scores";
         }

         @Override
         public String getDisplayName() {
             return displayName;
         }

     }

     private class BestScoresChildren extends Children.Keys<String> {
         private Preferences pref;
         public BestScoresChildren () {
             try {
                 pref = NbPreferences.forModule(Anagrams.class);
                 String[] keys = pref.keys();
                 if (keys != null && keys.length > 0) {
                     setKeys(keys);
                 } else {
                     setKeys(Collections.singleton(""));
                 }
             } catch (BackingStoreException ex) {
                 Exceptions.printStackTrace(ex);
             }
         }

         @Override
         protected Node[] createNodes(String key) {
             if (key.length() == 0) {
                 return new Node[] { new BestScoresNode("No scores", Children.LEAF) };
             } else {
                 return new Node[] { new BestScoresNode(key, pref.getInt(key, -1), Children.LEAF) };
             }
         }
     }

}
